CT_ViewLUTPlugin = 65536*68

plugins = fusion:GetRegList(CT_ViewLUTPlugin)
leftstr = comp:GetPrefs("Comp.Views.Left.Viewer.LUTPlugin")
--rightstr = comp:GetPrefs("Comp.Views.Right.Viewer.LUTPlugin")
--floatstr = comp:GetPrefs("Comp.Views.View1.Viewer.LUTPlugin")

left = 0
pluginList = {}
for i,reg in pairs(plugins) do
   pluginList[i] = reg.ID
   if reg.ID == leftstr then
      left = i-1
   end
end


viewList = { "Left", "Right", "View1", "View2", "View3", "View4", "View5" }
ctrls = {
{
   "View",
   "Dropdown",
   Options = viewList
},
{
   "Plugin List",
   "Dropdown",
   Options = pluginList,
   Default = left
},
{
   "Save in Global Prefs",
   "Checkbox",
   Default = 1
},
{
   "Save in Comp",
   "Checkbox",
   Default = 1
}
}

result = comp:AskUser("Select a View LUT plugin:", ctrls)

if result then
   view = viewList[result["View"] + 1]
   pluginID = pluginList[result["Plugin List"] + 1]

   if result["Save in Global Prefs"] == 1 then
      fusion:SetPrefs("Comp.Views."..view..".Viewer.LUTPlugin", pluginID)
	  fusion:SetData("LUTPlugin", pluginID)		-- this just forces SavePrefs()
   end
   if result["Save in Comp"] == 1 then
      comp:SetPrefs("Comp.Views."..view..".Viewer.LUTPlugin", pluginID)
   end
end
